// ******************************************************
// *                                                    *
// *  main.C (MP2)                                      *
// *                                                    *
// *  Driver file for testing MP2 classes               *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************

#include <iostream.h>
#include "named.h"
#include "string.h"
#include "array.h"
#include "mp2fns.h"

int main()
{
   NamedItem<int> jpOrder("James", "Pankow", 3);
   NamedItem<int> rlOrder("Robert", "Lamm", 4);
   NamedItem<int> wpOrder("Walt", "Parazadier", 1); 
   NamedItem<int> llOrder("Lee", "Loughnane", 2); 

   NamedItem<String> jpInstr(jpOrder.GetFirstName(), jpOrder.GetLastName(),
			 "Trombone");
   NamedItem<String> rlInstr(rlOrder.GetFirstName(), rlOrder.GetLastName(),
			"Keyboard");
   NamedItem<String> wpInstr(wpOrder.GetFirstName(), wpOrder.GetLastName(),
			"Woodwinds");
   NamedItem<String> llInstr(llOrder.GetFirstName(), llOrder.GetLastName(),
                        "Trumpet");

   NamedItem<String> jpInstr2(jpInstr);
   NamedItem<String> rlInstr2(rlInstr);
   NamedItem<String> wpInstr2(wpInstr);
   NamedItem<String> llInstr2(llInstr);

   Array<NamedItem<int> > orderArray(1, 4);

   orderArray[1] = jpOrder;
   orderArray[2] = rlOrder;
   orderArray[3] = wpOrder;
   orderArray[4] = llOrder;

   Array<NamedItem<String> > instArray(1, 4);

   instArray[1] = jpInstr2;
   instArray[2] = rlInstr2;
   instArray[3] = wpInstr2;
   instArray[4] = llInstr2;

   int order;

   if (RetrieveFromArray(String("Lamm"), orderArray, order))
      cout << "Order of Lamm is: " << order << endl; 
   else  
      cout << "Lamm not in array" << endl; 
   if (RetrieveFromArray(String("Pankow"), orderArray, order))
      cout << "Order of Pankow is: " << order << endl; 
   else  
      cout << "Pankow not in array" << endl; 
   if (RetrieveFromArray(String("Cetera"), orderArray, order))
      cout << "Order of Cetera is: " << order << endl; 
   else  
      cout << "Cetera not in array" << endl; 

   for (int i = 1; i<=4; i++)
      cout << ReturnFullName(instArray[i]) << endl; 


   return 0; 
}

