/* +++++[  MP1 - TEE CLASS  ]+++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                       +
   +  Name:   Mariusz Zaczek                                               +
   +  Class:  Tu 11-1                                                      +
   +  Date:   2-1-1999                                                     +
   +                                                                       +
   +  This is the Tee header file which declares the function to be used.  +
   +                                                                       +
   +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#ifndef TEE_H
#define TEE_H

/* +++++[ Class  Tee  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                                       +
   +  Class used to define Tee object:                                     +
   +                                                                       +
   +          *.*     *.*     *.*     ***                                  +
   +          *..     ...     ..*     ...                                  +
   +          *.*     ***     *.*     *.*                                  +
   +                                                                       +
   +           0       90     180     270                                  +
   +                                                                       +
   +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
class Tee
{
public:
   
   /* +++++[  Tee()  ]++++++++++++++++++++++++++++++++++++++++++++++++++++++
      +                                                                    +
      +   - parameters : none                                              +
      +                                                                    +
      +   - default constructor                                            +
      +   - initializes object to default values                           +
      +                                                                    +
      ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
   Tee(); 


   /* +++++[  OpenEntrance()  ]+++++++++++++++++++++++++++++++++++++++++++++
      +                                                                    +
      +   - function type: void                                            +
      +                                                                    +
      +   - parameters : enterNum - the number of the entrance we          +
      +       wish to open                                                 +
      +                                                                    +
      +   - if enterNum is a legal entrance number, close the entrance;    +
      +     otherwise, say it is illegal and return                        +
      +                                                                    +
      ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
   void OpenEntrance(int enterNum);


   /* +++++[  CloseEntrance()  ]++++++++++++++++++++++++++++++++++++++++++++
      +                                                                    +
      +   - function type: void                                            +
      +                                                                    +
      +   - parameters : enterNum - the number of the entrance we          +
      +       wish to close                                                +
      +                                                                    +
      +   - if enterNum is a legal entrance number, close the entrance;    +
      +     otherwise, say it is illegal and return                        +
      +                                                                    +
      ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
   void CloseEntrance(int enterNum);


   /* +++++[  Imprint()  ]++++++++++++++++++++++++++++++++++++++++++++++++++
      +                                                                    +
      +   - function type: void                                            +
      +                                                                    +
      +   - parameters : picArray - array to which we write the appropriate+
      +                     symbols to represent this tubing type          +
      +                : rLoc - row Coord of this object in placement array+
      +                : cLoc - column Coord of this object in placement   +
      +                      array                                         +
      +                                                                    +
      +                                                                    +
      +   -  writes the character group which represents this type to      +
      +        the appropriate location in the picture array               +
      +                                                                    +
      ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
   void Imprint(char picArray[9][9], int rLoc, int cLoc); 



   /* +++++[  Rotate()  ]+++++++++++++++++++++++++++++++++++++++++++++++++++
      +                                                                    +
      +   - function type: void                                            +
      +                                                                    +
      +   - rotates object to next orientation point -- in                 +
      +      this case, 90 degrees counter-clockwise.                      +
      +                                                                    +
      ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
   void Rotate(); 


private:

   /* 3x3 array of characters representing the types of objects used.        */
   char drawArray[3][3];
 
   /* Integer array of entrances: entrance[?]=0 is closed , 
                                  entrance[?]=1 is open */
   int entrance[3];

   /* Integer containing current orientation status of Tee object.           */
   int orientation; 

};

#endif TEE_H
