// ******************************************************
// *                                                    *
// *  tee.h (MP1)                                       *
// *                                                    *
// *  Interface for a class which models a              *
// *    tee-shaped tubing piece                         *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************

#ifndef _TEE_H
#define _TEE_H


class Tee
{
public:
   
   // Tee
   //    - default constructor
   //    - initializes object to default values
   Tee(); 


   // OpenEntrance
   //    - parameters : enterNum - the number of the entrance
   //                     we wish to open
   //    - if enterNum is a legal entrance number, open the 
   //        entrance; otherwise, say it is illegal and return
   void OpenEntrance(int enterNum);


   // CloseEntrance
   //    - parameters : enterNum - the number of the entrance
   //                     we wish to close 
   //    - if enterNum is a legal entrance number, close the 
   //        entrance; otherwise, say it is illegal and return
   void CloseEntrance(int enterNum);


   // Imprint
   //    - parameters : picArray - array to which we write the appropriate
   //                       symbols to represent this tubing type 
   //                 : xLoc - x-Coord of this object in placement array
   //                 : yLoc - y-Coord of this object in placement array 
   //    - writes the character group which represents this type to
   //        the appropriate location in the picture array 
   void Imprint(char picArray[9][9], int xLoc, int yLoc); 


   // Rotate
   //    - rotates object to next orientation point -- in 
   //       this case, 90 degrees counter-clockwise. 
   void Rotate(); 


private:

   char drawArray[3][3];
   int entrance[3];
   int orientation; 

};


#endif


