// ******************************************************
// *                                                    *
// *  straight.h (MP1)                                  *
// *                                                    *
// *  Interface for a class which models a              *
// *    straigh tubing piece                            *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************


#ifndef _STRAIGHT_H
#define _STRAIGHT_H

class Straight
{
public:
   
   // Straight
   //    - default constructor
   //    - initializes object to default values
   Straight(); 


   // OpenEntrance
   //    - parameters : enterNum - the number of the entrance
   //                     we wish to open
   //    - if enterNum is a legal entrance number, open the 
   //        entrance; otherwise, say it is illegal and return
   void OpenEntrance(int enterNum);


   // CloseEntrance
   //    - parameters : enterNum - the number of the entrance
   //                     we wish to close 
   //    - if enterNum is a legal entrance number, close the 
   //        entrance; otherwise, say it is illegal and return
   void CloseEntrance(int enterNum);


   // Imprint
   //    - parameters : picArray - array to which we write the appropriate
   //                       symbols to represent this tubing type 
   //                 : xLoc - x-Coord of this object in placement array
   //                 : yLoc - y-Coord of this object in placement array 
   //    - writes the character group which represents this type to
   //        the appropriate location in the picture array 
   void Imprint(char picArray[9][9], int xLoc, int yLoc); 


   // Rotate
   //    - rotates object to next orientation point -- in 
   //       this case, back and forth between being oriented
   //       at 0 degrees and oriented at 90 degrees 
   void Rotate(); 


private:

   char drawArray[3][3];
   int entrance[2];
   int orientation;
};


#endif
