// ******************************************************
// *                                                    *
// *  main.C (MP1)                                      *
// *                                                    *
// *  Driver file for testing MP1 classes               *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************


#include <iostream.h>
#include "fill.h"
#include "cross.h"
#include "bend.h"
#include "tee.h"
#include "straight.h"
#include "indicator.h"
#include "print.h"

int main()
{
   Fill* fillArray = new Fill[10];
   Cross* crossArray = new Cross[10];
   Bend* bendArray = new Bend[10];
   Tee* teeArray = new Tee[10];
   Straight* straightArray = new Straight[10];

   int fillCount = 0;
   int crossCount = 0;
   int bendCount = 0; 
   int teeCount = 0; 
   int straightCount = 0; 

   Indicator* positionArray[3][3];

   positionArray[0][0] = new Indicator('b', bendCount++);    
   positionArray[0][1] = new Indicator('b', bendCount++);

   bendArray[1].Rotate(); 

   positionArray[0][2] = new Indicator('b', bendCount++);
   positionArray[1][0] = new Indicator('t', teeCount++);

   teeArray[0].Rotate(); 

   positionArray[1][1] = new Indicator('c', crossCount++);
   positionArray[1][2] = new Indicator('c', crossCount++); 
   positionArray[2][0] = new Indicator('f', fillCount++);
   positionArray[2][1] = new Indicator('s', straightCount++);

   straightArray[0].Rotate(); 

   positionArray[2][2] = new Indicator('t', teeCount++);

   char picArray[9][9];
   
   char tempChar; 
   int tempIndex; 

   for (int i = 0; i<=2; i++)
   {
      for (int j = 0; j<=2; j++)
      {
         tempChar = (positionArray[i][j])->GetClassChoice(); 
         tempIndex = (positionArray[i][j])->GetClassIndex(); 

         if (tempChar == 'f')
            fillArray[tempIndex].Imprint(picArray, i, j); 
         else if (tempChar == 'c')
            crossArray[tempIndex].Imprint(picArray, i, j); 
         else if (tempChar == 'b')
            bendArray[tempIndex].Imprint(picArray, i, j); 
         else if (tempChar == 't')
            teeArray[tempIndex].Imprint(picArray, i, j); 
         else if (tempChar == 's')
            straightArray[tempIndex].Imprint(picArray, i, j); 
         else
            cout << "Corrupted indicator at " << i << ", " << j << endl;
      }
   }

   cout << "We have " << fillCount << " Fill objects in our grid." << endl; 
   cout << "We have " << crossCount << " Cross objects in our grid." << endl; 
   cout << "We have " << bendCount << " Bend objects in our grid." << endl; 
   cout << "We have " << teeCount << " Tee objects in our grid." << endl; 
   cout << "We have " << straightCount << " Straight objects in our grid." << endl; 
   cout << endl;  
 


   Print(picArray); 

   for (i = 0; i<=2; i++)
      for (int j = 0; j<=2; j++)
         delete (positionArray[i][j]); 
  
   delete[] fillArray;
   delete[] crossArray; 
   delete[] bendArray;
   delete[] teeArray; 
   delete[] straightArray; 


   return 0; 
}

