// ******************************************************
// *                                                    *
// *  fill.C (MP1)                                      *
// *                                                    *
// *  Implementation for a class which models a         *
// *    filled tubing piece (i.e. a lack of tubing)     *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************

#include "fill.h"


// Fill
//    - default constructor
//    - initializes object to default values
Fill::Fill()
{
   for (int i = 0; i<=2; i++)
      for (int j = 0; j<=2; j++)
         drawArray[i][j] = '*';
}


// Imprint
//    - parameters : picArray - array to which we write the appropriate
//                       symbols to represent this tubing type 
//                 : rLoc - row Coord of this object in placement array
//                 : cLoc - column Coord of this object in placement array 
//    - writes the character group which represents this type to
//        the appropriate location in the picture array 
void Fill::Imprint(char  picArray[9][9], int rLoc, int cLoc)
{
   for (int i = 0; i<=2; i++)
      for (int j = 0; j<=2; j++)
         picArray[3*rLoc+i][3*cLoc+j] = drawArray[i][j];
}
