// ******************************************************
// *                                                    *
// *  bend.C (MP1)                                      *
// *                                                    *
// *  Implementation for a class which models a         *
// *    bend-shaped tubing piece                        *
// *                                                    *
// *  Written 28 Jan 1999 by Jason Zych                 *
// *                                                    *
// ******************************************************

#include <iostream.h>
#include "bend.h"

// Bend
//    - default constructor
//    - initializes object to default values
Bend::Bend()
{
   entrance[0] = 1;  // entrances open 
   entrance[1] = 1; 
  
   // writing    ***
   //            ..*
   //            *.*
   // to the draw array 

   for (int j = 0; j<=2; j++)
      drawArray[0][j] = drawArray[j][2] = '*';
   drawArray[2][0] = '*';

   drawArray[1][1] = '.';
   drawArray[1][0] = drawArray[2][1] = '.';
 
   orientation = 45; 
}


// OpenEntrance
//    - parameters : enterNum - the number of the entrance
//                     we wish to open
//    - if enterNum is a legal entrance number, open the 
//        entrance; otherwise, say it is illegal and return
void Bend::OpenEntrance(int enterNum)
{
   if ((enterNum < 0) || (enterNum > 1))
      cout << "That is not a legal entrance number for this object!" << endl; 
   else
      entrance[enterNum] = 1;
}


// CloseEntrance
//    - parameters : enterNum - the number of the entrance
//                     we wish to close 
//    - if enterNum is a legal entrance number, close the 
//        entrance; otherwise, say it is illegal and return
void Bend::CloseEntrance(int enterNum)
{
   if ((enterNum < 0) || (enterNum > 1))
      cout << "That is not a legal entrance number for this object!" << endl; 
   else
      entrance[enterNum] = 0;
}


// Imprint
//    - parameters : picArray - array to which we write the appropriate
//                       symbols to represent this tubing type 
//                 : rLoc - row Coord of this object in placement array
//                 : cLoc - column Coord of this object in placement array 
//    - writes the character group which represents this type to
//        the appropriate location in the picture array 
void Bend::Imprint(char picArray[9][9], int rLoc, int cLoc)
{
   for (int i = 0; i<=2; i++)
      for (int j = 0; j<=2; j++)
         picArray[3*rLoc + i][3*cLoc + j] = drawArray[i][j];
}


void Bend::Print()
{
  for (int i = 0; i<=2; i++) 
  { 
    for (int j = 0; j<=2; j++)
      cout << drawArray[i][j];
   
    cout << endl;
  }
  return;
}


// Rotate
//    - rotates object to next orientation point -- in 
//       this case, 90 degrees counter-clockwise. 
void Bend::Rotate()
{
   if (orientation == 45)
   {
      drawArray[1][2] = '.';
      drawArray[1][0] = '*';
   }
   else if (orientation == 135)
   {
      drawArray[0][1] = '.';
      drawArray[2][1] = '*';
   }
   else if (orientation == 225)
   {
      drawArray[1][2] = '*';
      drawArray[1][0] = '.';
   }
   else if (orientation == 315)
   {
      drawArray[0][1] = '*';
      drawArray[2][1] = '.';
   }
   else
      cout << "Error in Bend::Rotate(): corrupted orientation" << endl;


   orientation += 90;
   if (orientation > 360)
      orientation -= 360;
} 
