/* ++[   MP6 - student.C  ]++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Zaczek, Mariusz                                            +
   + CS 223 - Monday 11:00am - 1:00 pm                          +
   + 5/1/98                                                     +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#include <iostream.h>
#include "student.h"

/* ++[  A  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Student constructor (default)                             +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Student::Student() {}

/* ++[  B  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Student constructor                                       +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Student::Student(long stu_ssn,char *stu_name,int stu_major,
                 double stu_units,int stu_grade) 
{ 
  /* Copy variables to data members */
  ssn = stu_ssn;
  strcpy(name,stu_name);
  major = stu_major;
  units = stu_units;
  grade = stu_grade;
}

/* ++[  C  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Graduate constructor                                      +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Graduate::Graduate(long stu_ssn,char *stu_name,int stu_major,
	 	   double stu_units,int stu_grade,int stu_status) 
         : Student(stu_ssn,stu_name,stu_major,stu_units,stu_grade)
{ 
  status = stu_status;  
}

/* ++[  D  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  get_grade - return grade                                  +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
int Student::get_grade()
{
  return grade;
}

/* ++[  E  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  change_grade - changes student's grade                    +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Student::change_grade(int new_grade)
{
  /* Change the grade to new grade */
  grade = new_grade;
  return;
}

/* ++[  F  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  change_units - changes student's units                    +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Student::change_units(double new_units)
{
  /* Change the units to new units */
  units = new_units;
  return;
}

/* ++[  G  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Undergraduate constructor                                 +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Undergraduate::Undergraduate(long stu_ssn,char *stu_name,int stu_major,
	 	   double stu_units,int stu_grade,int stu_year) 
         : Student(stu_ssn,stu_name,stu_major,stu_units,stu_grade)
{ 
  year = stu_year;  
}

/* ++[  H  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Overloaded << operator - prints out student info          +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
ostream &operator<<(ostream &output,Student * stu)
{
  /* Print out the info for each student */
  stu->print(stu->ssn,stu->name,stu->major,stu->units,stu->grade);

  return output;
}

/* ++[  I  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Student print function - does nothing                      +   
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Student::print(long s, char *n, int m, double u, int g) { }

/* ++[  J  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Graduate print function                                    +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Graduate::print(long s, char *n, int m, double u, int g)
{
  cout << s << " "
       << n << " "
       << m << " "
       << u << " "
       << g << " "
       << status;

  return;
}

/* ++[  K  }+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Undergraduate print function                              +
   +                                                            + 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Undergraduate::print(long s, char *n, int m, double u, int g)
{
  cout << s << " "
       << n << " "
       << m << " "
       << u << " "
       << g << " "
       << year;
     
  return;
}
