/* ++[  Machine Problem 6  ]+++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Zaczek, Mariusz                                            +
   + CS 223 - Monday 11:00am - 1:00 pm                          +
   + 4/25/98                                                    +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#include <iostream.h>
#include "student.h"
#include "collection.h"
#include "collection.C"
template class cCollection<int>;
template class cCollection<Student*>;

/* Declare functions */
void make_histogram(cCollection<int>& array,cCollection<Student*>& stu_array);
void histogram(cCollection<int>& array);

/* Main Program */
int main()
{
  /* Declare variables */
  int menu_choice,major,status,year,grade;
  int position,new_grade;
  long ssn;
  double units,new_units;
  char name[256];
  Graduate* grad_stu;
  Undergraduate* undergrad;

  /* Declare arrays of cCollection type */
  cCollection<Student*> stu_array(0,5);
  cCollection<int> histogram_array(0,101);

  /* Main body of menu portion of program */
  do
  {
    /* Display menu of choices and read in choice */
    cout << "\nCreate Grad(1), Ugrad (2), Print(3), Histogram(4), "
        << "\n\tChange Grade(5), Change Units(6), or Exit(0) ? "
         << endl;
    cin >> menu_choice;
  
    /* Test to make sure choice entered is within bounds. If not,
       prompt again  */
    while ( (menu_choice < 0) || (menu_choice > 6) )
    {  
      cout << "Invalid Choice. Try again: ";
      cin >> menu_choice;
    }

    /* Switch used to call appropriate routines based on choice from
       menu above */
    switch(menu_choice)
    {
      case 0:
        return 0;
      /* Prompt for Grad information */
      case 1:
        cout << "Enter SSN (9 digits): ";
        cin >> ssn;
        cout << "Enter name (MAX 256) (one word only): ";
        cin >> name;
        cout << "Enter major(CS=1, EE=2, LAS=3, Other=4): ";
        cin >> major;
        cout << "Enter units_enrolled(float, "
             << "1 hour = .25 units, MAX 1): ";  
        cin >> units;
        cout << "Enter Grade(0 - 100): ";
        cin >> grade;
        cout << "Enter employment status(TA=1, "
             << "RA=2, Fellow=3, Other=4): ";
        cin >> status;

        /* Insert Grad into the student array */
        grad_stu = new Graduate(ssn,name,major,units,grade,status);
        stu_array.AddElem(grad_stu);
        break;

      /* Prompt for Undergrad information */
      case 2:
        cout << "Enter SSN (9 digits): ";
        cin >> ssn; 
        cout << "Enter name (MAX 256) (one word only): ";
        cin >> name;
        cout << "Enter major(CS=1, EE=2, LAS=3, Other=4): "; 
        cin >> major;
        cout << "Enter units_enrolled(float, "
             << "1 hour = .25 units, MAX 1): ";
        cin >> units;
        cout << "Enter Grade(0 - 100): ";
        cin >> grade; 
        cout << "Enter year in school(1-7): ";
        cin >> year;

        /* Insert Undergrad into student array */
        undergrad = new Undergraduate(ssn,name,major,units,grade,year);   
        stu_array.AddElem(undergrad);
        break;
      case 3:
        /* Print out students in the array */
        cout << stu_array;
        break;
      case 4:
        /* Print out histogram */
        cout << "Histogram" << endl;
        make_histogram(histogram_array,stu_array);
        break;
      case 5:
        /* Change grade */
	cout << "Enter Student number: " ;
        cin >> position;
        cout << "Enter new grade (0-100): " ;
        cin >> new_grade;
	stu_array[position]->change_grade(new_grade);
        break;
      case 6:
        /* Change units */
        cout << "Enter Student number: " ;
        cin >> position;
        cout << "Enter new units (0.00-1.00): " ;
        cin >> new_units;
        stu_array[position]->change_units(new_units); 
        break;
      default:
	break;	
    } 
    
  }while (menu_choice != 0);

return 0;
}
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Function to make array of integers representing the grades +
   + of the students and how many of the type of grade there is.+ 
   + This function runs through the student array picking off   +
   + the grades and updating the int array position             +
   + corresponding to the particular date.                      +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

void make_histogram(cCollection<int>& array,cCollection<Student*>& stu_array)
{

  for (int i=0;i<stu_array.Length();i++)
    array[stu_array[i]->get_grade()]++;
  
  histogram(array);
  
  return;  
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + This function print out the histogram.                     +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void histogram(cCollection<int>& array)
{ 
  int i,j,k,place=100;
   
  /* Print out the first line 100%-97% */
  cout << "100%-97%  ";
  for (i=place;i>place-4;i--)
    for (j=0;j<array[i];j++)
      cout << "*";   
  cout << endl;

  /* Print out the second line 96%-93% */
  place = 96;
  cout << "96%-93%   ";
  for (i=place;i>place-4;i--)
    for (j=0;j<array[i];j++) 
      cout << "*";         
  cout << endl;

  /* Print out the rest */
  place = 92;   
  for (k=0;k<31;k++)
  {
    cout << place << "%-" << place-2 << "%   ";
    for (i=place;i>place-3;i--)
      for (j=0;j<array[i];j++)
      cout << "*";
    cout << endl;
    place -= 3;
  }

  /* Clear the array */
  for (int z=0;z<101;z++)
    array[z]=0;
       
return;
}

