/* ++[  Machine Problem 5  ]+++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Zaczek, Mariusz                                            +
   + CS 223 - Monday 11:00am - 1:00 pm                          +
   + 4/13/98                                                    +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#include <iostream.h>
#include "mfc.h"
#include "malice.h" 

/* Declare 'menu_two' function which is written below the main */
void menu_two(MFC *instance);

/* Main Program */
int main()
{
  /* Declare variables, including instance of MFC class */
  MFC *instance;
  int firstchoice;

  /* Perform DO-LOOP to prompt user for the type of program
     to use and depending on which selection is made call
     menu_two sending it the instance of the class required */
  do 
  {
    /* Prompt for choice of program or 0 to exit */
    cout << "Please choose from one of the following options:\n"
         << " 1. MaliceSoft\n"
         << " 2. NaiveScape\n"
         << " 0. exit" 
         << endl;
    cin >> firstchoice;
  
    /* Switch statements determines what action to take based on
       choice selected above */
    switch(firstchoice)
    {
      /* MALICE - MaliceSoft */
      case 1:
        instance = new Malice();
        menu_two(instance);
        break;
      /* MFC - NaiveScape */
      case 2:
        instance = new MFC();
        menu_two(instance);
        break;
      /* If zero is entered, exit */
      case 0:
        return 0;
      /* Error message is displayed in case an invalid choice
         is made */
      default:     
        cout << "Invalid option" << endl;
    } 
    /* Continue on until choice is 0 */
  } while ( firstchoice != 0 );

  return 0;
}

/* Menu_two function which displays menu_two and prompt the user
   for action to take. */
void menu_two(MFC *instance)
{
  /* Declare variables */
  int secondchoice;
 
  /* DO-LOOP to loop until choice entered is 0 for exit */
  do
  { 
    /* Prompt user to enter what should be done with the array
       of doubles */
    cout << "Please choose from one of the following options:\n"
         << " 1. insert\n"
         << " 2. print\n"
         << " 3. round\n"
         << " 4. sort\n"
         << " 0. exit"
         << endl;
     cin >> secondchoice;

    /* Switch statement takes appropriate action based on choice */
    switch(secondchoice)
    {
      /* Attempt to insert data into array slot if any are open */
      case 1:
        cout << "Please enter a double precision data to insert" << endl;
        double data;
        cin >> data;
        instance -> insert(data);
        break;
      /* Print out the array */
      case 2:
        instance -> print();
        break;
      /* Enter position to round in the array: MFC = Truncate,
	 Malice = IEEE 754 */
      case 3:
        cout << "Please enter the index of the element to round" << endl;
        int position;
        cin >> position;
        instance -> round(position);
        break;
      /* Sort the array: MFC = Bubble Sort , Malice = Merge Sort */
      case 4:
        instance -> sort();
        break;
      case 0:
        return;
      /* Error message for invalid input */
      default:
        cout << "Invalid option" << endl;
    }
  } while (secondchoice != 0); 

return;
}
