/* ++[   MP5 - malice.C  ]+++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Zaczek, Mariusz                                            +
   + CS 223 - Monday 11:00am - 1:00 pm                          +
   + 4/13/98                                                    + 
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#include <iostream.h>
#include "malice.h"    
#include "mfc.h"

/* ++[ Declare functions ]+++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  void mergesort( double a[], int start, int end)		+
   +      - main Merge Sort function				+
   +								+
   +  void merge( double a[], int start, int middle, int end )  +
   +      - this function combines the two arrays		+
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void mergesort( double a[], int start, int end);
void merge( double a[], int start, int middle, int end );

/* ++[  A  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  ostream &operator<<(ostream &output,Malice &array)	+
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
ostream &operator<<(ostream &output,Malice &array)
{  
  int arraysize = array.get_size();
  for(int j=0;j<arraysize-1;j++)
    output << *(array.get_array() + j) << ", ";

    output << *(array.get_array() + arraysize-1) << endl;
  return output;
}

/* ++[  B  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  Malice - constructor                                      +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Malice::Malice() : MFC() { }

/* ++[  C  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  void Malice::print()					+
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Malice::print() 
{
  cout << *this;

  return;
}
  
/* ++[  D  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  void Malice::round(int position)				+
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Malice::round(int position)
{
  double value = *(MFC::get_array() + position);

  if ((value - (int)value) >= 0.5)
    *(MFC::get_array() + position) = (int)value + 1;
  else
    *(MFC::get_array() + position) = (int)value;

  return;
}         

/* ++[  E  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   +  void Malice::sort()					+
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Malice::sort()
{

  int size = MFC::get_size();
 
  mergesort(MFC::get_array(),0,size-1);

  cout << "Merge Sort: ";
  print();

  return;
}

/* ++[  F  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +  Function: 						+
   +    void mergesort( double a[], int start, int end) 	+
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void mergesort( double a[], int start, int end)
{
  if (start < end)
  {
    int middle = (start + end) / 2;
    mergesort(a, start, middle);
    mergesort(a, middle + 1, end);
    merge(a, start, middle, end);
  }
  return;
}

/* ++[  F  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +  Function:                                                 +
   +    void merge( double a[], int start, int middle, int end) +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */ 
void merge( double a[], int start, int middle, int end)
{
  int i, j, k=0;
  double temp[32];

   i = start;
   j = middle + 1;

   while( i <= middle && j <= end )
      if( a[i] < a[j] )
         temp[k++] = a[i++];
      else
         temp[k++] = a[j++];

   while( i <= middle )
      temp[k++] = a[i++];
   while( j <= end )
      temp[k++] = a[j++];

  for(i = start, k = 0; i <= end; ++i, ++k )
      a[i] = temp[k];

  return;
}

