/* ++[   MP4 - Student.C  ]++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Zaczek, Mariusz                                            +
   + CS 223 - Monday 11:00am - 1:00 pm                          +
   + 4/1/98                                                     +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>
#include "Student.h"

/* ++[  A  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Student::Student()                                         +
   +                                                            +
   +  - Acts as the constructor.                                +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Student::Student() 
{
  next = NULL; 
}

/* ++[  B  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void Student::printGrade()                                 +
   +                                                            +
   +  - Prints out the grade                                    +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Student::printGrade()
{
  cout << ssno 
       << setprecision(1)
       << setiosflags(ios::fixed | ios::showpoint)
       << "\t\t"
       << finalScore << "\t" << grade << endl;
  return;  
}

/* ++[  C  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void Student::set_final_score(double s)                    +
   +                                                            +
   +  - Sets the final score					+
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Student::set_final_score(double s)
{
  finalScore = s;
  return;
}

/* ++[  D  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void Student::set_final_grade(char g)                      +
   +                                                            +
   +  - Sets the final grade					+
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Student::set_final_grade(char g)
{
  grade = g;
  return;
}

/* ++[  E  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + RegularStudent::RegularStudent() : Student() 		+
   +                                                            +
   +  - Constructor for Derived RegularStudent Class		+
   +								+ 
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
RegularStudent::RegularStudent() : Student() { }

/* ++[  F  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void RegularStudent::computeGrade(double score)            +
   +                                                            +
   +  - Determines the grade (A,B,C,D or F)			+
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void RegularStudent::computeGrade(double score)
{
  if ((score <= 100.0) && (score > 85.0))
    set_final_grade('A');
  else if ((score <= 85.0) && (score > 65.0))
    set_final_grade('B');
  else if ((score <= 65.0) && (score > 45.0))
    set_final_grade('C');
  else if ((score <= 45.0) && (score > 30.0))
    set_final_grade('D');
  else if (score <= 30.0)
    set_final_grade('F');

  return;
}

/* ++[  G  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void RegularStudent::computeFinalScore(int id_no,		+
   + 					double s1,s2,s3)    	+        
   +                                                            +
   +  - Calls the set_id() function				+
   +  - Computes the score and calls the set_final_score funct. +
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void RegularStudent::computeFinalScore(int id_no,double s1,double s2,double s3)
{
  set_id(id_no);
  score = (s1 + s2 + s3) / 3.0;
  computeGrade(score);
  set_final_score(score);
  return;
}

/* ++[     ]+++++++++++++++++++++++++++++++++++++++++++++++++++++    
   +                                                            +    
   + void Student::set_id(int id)				+
   +								+
   +  - Sets the student id					+
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Student::set_id(int id)
{
  ssno = id;
  return;
}

/* ++[  H  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + ProficiencyStudent::ProficiencyStudent() : Student()	+
   +                                                            +
   +  - Constructor for Derived ProficiencyStudent Class        +
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
ProficiencyStudent::ProficiencyStudent() : Student() {}

/* ++[  I  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void ProficiencyStudent::computeGrade(double score)        +
   +                                                            +
   +  - Determines the grade (A,B,C,D or F)                     +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void ProficiencyStudent::computeGrade(double score)
{
  if ((score <= 100.0) && (score > 90.0))
    set_final_grade('A');
  else if ((score <= 90.0) && (score > 80.0))
    set_final_grade('B');
  else if ((score <= 80.0) && (score > 70.0))
    set_final_grade('C');
  else if ((score <= 70.0) && (score > 60.0))
    set_final_grade('D');
  else if (score <= 60.0)
    set_final_grade('F');

  return;
}

/* ++[  J  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void ProficiencyStudent::computeFinalScore(int id_no,	+
   +						double s1,s2)   +
   +                                                            +
   +  - Calls the set_id() function                             +
   +  - Computes the score and calls the set_final_score funct. +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void ProficiencyStudent::computeFinalScore(int id_no,double s1, double s2)
{
  set_id(id_no);
  score = (s1 + s2) / 2.0;
  computeGrade(score);
  set_final_score(score);
  return;
}

/* ++[  K  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + double Student::GetFinalScore()				+
   +								+
   +  - Returns the final score (double)			+
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
double Student::GetFinalScore()
{ 
  return finalScore;
}

/* ++[  L  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void Student::set_Next_Student(Student *new_next)		+
   +                                                            +
   +  - Sets the next student to next.				+
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Student::set_Next_Student(Student *new_next)
{
  next = new_next;
  return;
}

/* ++[  M  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + Student *Student::get_Next_Student()			+
   +                                                            +
   +  - returns the next student				+
   +								+   
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
Student *Student::get_Next_Student() 
{
  return next;
}

/* ++[  N  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + List::List()						+
   +                                                            +
   +  - Constructor for the List				+
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
List::List()
{
  dummy = new Student();
}

/* ++[  O  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +   
   + List::~List()                                              +
   +                                                            +
   +  - Desstructor for the List                                +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
List::~List()
{
  delete dummy;
}

/* ++[  P  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void Student::Insert(Student *data,Student *dummy)		+
   +                                                            +
   +  - Inserts the student into the appropriate position 	+
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void Student::Insert(Student *data,Student *dummy)
{
  /* If you are last in line then add the student to the list. */
  if (next == NULL)
    next = data;
  /* Otherwise if the Newgrade is bigger then the next than 
     insert it after the next */
  else
  {
    double NextGrade = dummy -> GetFinalScore();
    double NewGrade = data -> GetFinalScore();
    if (NewGrade >= NextGrade)
    {
      data -> set_Next_Student(next);
      next = data;
    }
    else
      next -> Insert(data,dummy -> get_Next_Student());     
  } 
  return;
}

/* ++[  Q  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +   
   + void List::InsertStudent(Student *data)                    +
   +                                                            +
   +  - Inserts the student into the appropriate position       +
   +                                                            +
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void List::InsertStudent(Student *d)
{
  dummy -> Insert(d,dummy -> get_Next_Student());
  return;
}

/* ++[  R  ]+++++++++++++++++++++++++++++++++++++++++++++++++++++
   +                                                            +
   + void List::Print()						+
   +                                                            +
   +  - Print the contents of the linked list			+
   +								+
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
void List::Print()
{
  Student *temp = dummy -> get_Next_Student();
  while (temp != NULL)
  {
    temp -> printGrade();
    temp = temp -> get_Next_Student();
  }
  return;
}

