/*
 * Decompiled with CFR 0.152.
 */
import com.sun.opengl.util.FPSAnimator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLJPanel;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TestFPS
extends JPanel {
    private GLJPanel canvas;
    private Renderer renderer;
    private Font infoFont = new Font("MonoSpaced", 1, 14);
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private int width;
    private int height;
    private DecimalFormat format = new DecimalFormat("#######0.00000");
    private FPSAnimator animator;
    public static final boolean ANIMATOR_OFF = false;
    public static final boolean ANIMATOR_ON = true;
    protected boolean useAnimator = true;
    static final String ZEROES = "000000000000";
    static final String BLANKS = "            ";
    public boolean emulateFPS = true;
    private static Timer testTimer;

    static String format(double val, int n, int w) {
        double incr = 0.5;
        for (int j = n; j > 0; --j) {
            incr /= 10.0;
        }
        if (Math.abs(val += incr) < 1.0E-5) {
            val = 0.0;
        }
        String s = Double.toString(val);
        int n1 = s.indexOf(46);
        int n2 = s.length() - n1 - 1;
        if (n > n2) {
            s = s + ZEROES.substring(0, n - n2);
        } else if (n2 > n) {
            s = s.substring(0, n1 + n + 1);
        }
        if (w > 0 & w > s.length()) {
            s = BLANKS.substring(0, w - s.length()) + s;
        } else if (w < 0 & -w > s.length()) {
            w = -w;
            s = s + BLANKS.substring(0, w - s.length());
        }
        return s;
    }

    public TestFPS() {
        this(true);
    }

    public TestFPS(boolean useAnimator) {
        this.useAnimator = useAnimator;
        this.width = 640;
        this.height = 480;
        this.renderer = new Renderer(this.width, this.height);
        MouseHandler inputMouseHandler = new MouseHandler(this.renderer, this);
        this.addMouseListener(inputMouseHandler);
        this.addMouseMotionListener(inputMouseHandler);
        KeyHandler inputKeyHandler = new KeyHandler(this.renderer, this);
        this.setFocusable(true);
        this.addKeyListener(inputKeyHandler);
        this.setLayout(new BorderLayout());
        GLCapabilities caps = new GLCapabilities();
        caps.setAlphaBits(8);
        this.canvas = new GLJPanel(caps){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Color.WHITE);
                g.setFont(TestFPS.this.infoFont);
                String tmpString = "";
                if (((TestFPS)TestFPS.this).renderer.camera.getEmulateFPS()) {
                    g.drawString("FPS Emulation", 20, 20);
                } else {
                    g.drawString("Free Fly Through - with view rotation", 20, 20);
                }
                g.setColor(Color.YELLOW);
                if (((TestFPS)TestFPS.this).renderer.camera.getOrbit()) {
                    g.drawString("ORBITING Mode", 20, 35);
                } else {
                    g.drawString("Standard Mode", 20, 35);
                }
                g.setColor(Color.WHITE);
                tmpString = "   eye point: " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getEye().x) + ",  " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getEye().y) + ",  " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getEye().z);
                g.drawString(tmpString, 25, this.getHeight() - 55);
                tmpString = " look vector: " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getLook().x) + ",  " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getLook().y) + ",  " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getLook().z);
                g.drawString(tmpString, 25, this.getHeight() - 40);
                tmpString = "   up vector: " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getUp().x) + ",  " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getUp().y) + ",  " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getUp().z);
                g.drawString(tmpString, 25, this.getHeight() - 25);
                tmpString = "right vector: " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getRightCopy().x) + ",  " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getRightCopy().y) + ",  " + TestFPS.this.format.format(((TestFPS)TestFPS.this).renderer.camera.getRightCopy().z);
                g.drawString(tmpString, 25, this.getHeight() - 10);
                g.setColor(Color.WHITE);
                double[] v = ((TestFPS)TestFPS.this).renderer.camera.getViewCopy();
                g.drawString("View Matrix: ", 20, 60);
                g.drawString(TestFPS.format(v[0], 6, 10) + ", " + TestFPS.format(v[1], 6, 10) + ", " + TestFPS.format(v[2], 6, 10) + ", c" + TestFPS.format(v[3], 6, 10), 20, 75);
                g.drawString(TestFPS.format(v[4], 6, 10) + ", " + TestFPS.format(v[5], 6, 10) + ", " + TestFPS.format(v[6], 6, 10) + ", c" + TestFPS.format(v[7], 6, 10), 20, 90);
                g.drawString(TestFPS.format(v[8], 6, 10) + ", " + TestFPS.format(v[9], 6, 10) + ", " + TestFPS.format(v[10], 6, 10) + ", c" + TestFPS.format(v[11], 6, 10), 20, 105);
                g.drawString(TestFPS.format(v[12], 6, 10) + ", " + TestFPS.format(v[13], 6, 10) + ", " + TestFPS.format(v[14], 6, 10) + ", c" + TestFPS.format(v[15], 6, 10), 20, 120);
                g.setColor(Color.RED);
                g.drawString("Press 'O' to toggle between 1st person and 3rd person modes.", 20, 140);
                g.drawString("Press '3' to reset the view.", 20, 155);
            }
        };
        this.canvas.setOpaque(false);
        this.canvas.addGLEventListener((GLEventListener)this.renderer);
        this.canvas.setIgnoreRepaint(true);
        this.add((Component)this.canvas);
        this.setPreferredSize(new Dimension(this.width, this.height));
        if (useAnimator) {
            this.animator = new FPSAnimator((GLAutoDrawable)this.canvas, 30, true);
            this.animator.setRunAsFastAsPossible(false);
            this.start();
        }
    }

    public int getAnswerToLifeTheUniverseAndEverything() {
        return 42;
    }

    public void start() {
        try {
            this.canvas.requestFocus();
            this.animator.start();
        }
        catch (Exception e) {
            System.out.println("Caught Exception: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.animator.stop();
        }
        catch (Exception e) {
            System.out.println("Caught Exception: " + e);
        }
        finally {
            System.exit(0);
        }
    }

    public void drawabledisplay() {
        try {
            this.renderer.camera.apply();
            this.canvas.display();
        }
        catch (Exception e) {
            System.out.println("drawabledisplay(): Exception caught: " + e);
        }
    }

    public static void main(String[] args) {
        TestFPS proxView = new TestFPS(true);
        JFrame mFrame = new JFrame("First Person Shooter - Observer Controls");
        mFrame.getContentPane().setLayout(new BoxLayout(mFrame.getContentPane(), 1));
        mFrame.getContentPane().add(proxView);
        mFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        mFrame.pack();
        mFrame.setVisible(true);
    }

    public void testAnimation() {
        testTimer = new Timer(10, new TestAnimator(this, this.renderer));
        testTimer.setInitialDelay(3000);
        testTimer.start();
    }

    private static class TestAnimator
    implements ActionListener {
        private TestFPS thePanel = null;
        private Renderer renderer = null;
        private int count = 0;

        private TestAnimator(TestFPS thePanel, Renderer renderer) {
            this.thePanel = thePanel;
            this.renderer = renderer;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.thePanel != null) {
                double angle = (double)this.count * 2.0 * Math.PI / 180.0;
                double c = 2.0 * Math.cos(angle);
                double s = 2.0 * Math.sin(angle);
                this.renderer.camera.setEye(new Vector3d(s, c, 0.0));
                this.renderer.camera.lookAt(new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0));
                if (!this.thePanel.useAnimator) {
                    this.thePanel.drawabledisplay();
                }
                ++this.count;
                if (this.count > 180) {
                    testTimer.stop();
                }
            }
        }
    }
}

