/*
 * Decompiled with CFR 0.152.
 */
import com.sun.opengl.util.GLUT;
import java.awt.Point;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public class Renderer
implements GLEventListener {
    private GLU glu = new GLU();
    private GLUquadric starSphere;
    private float[] lightAmbient = new float[]{0.08f, 0.08f, 0.08f, 0.0f};
    private float[] lightDiffuse = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    private float[] lightSpecular = new float[]{0.15f, 0.15f, 0.15f, 0.0f};
    private float[] lightAmbientDiffuse = new float[]{0.65f, 0.65f, 0.65f, 0.0f};
    private float[] lightPosition = new float[]{100.0f, 0.0f, 0.0f, 1.0f};
    public double nearPlane = 0.001;
    public double farPlane = 2000000.0;
    public double zoomFactor = 0.01;
    private int _width;
    private int _height;
    public boolean reset = false;
    public Vector3d vEye = new Vector3d(1.0, 1.0, 1.0);
    public Vector3d vLook = new Vector3d(-0.05, -0.05, -0.05);
    public Vector3d vUp = new Vector3d(0.0, 1.0, 0.0);
    public Vector3d vRight = new Vector3d(1.0, 0.0, 0.0);
    public Point lastMousePoint = new Point();
    public Point currentMousePoint = new Point();
    public Camera camera = new Camera();

    Renderer(int width, int height) {
        this._width = width;
        this._height = height;
        this.camera.setEye(new Vector3d(0.0, 0.0, -2.0));
        this.camera.lookAt(new Vector3d(0.0, 0.0, 0.0), new Vector3d(1.0, 0.0, 0.0));
    }

    public void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.setSwapInterval(1);
        gl.glViewport(0, 0, 320, 240);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(65.0, 1.3333333333333333, this.nearPlane, this.farPlane);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glShadeModel(7425);
        gl.glMaterialfv(1028, 4610, this.lightSpecular, 0);
        gl.glMaterialfv(1028, 5634, this.lightAmbientDiffuse, 0);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gl.glClearDepth(1.0);
        gl.glClearStencil(0);
        gl.glEnable(2929);
        gl.glHint(3152, 4354);
        gl.glLightfv(16384, 4608, this.lightAmbient, 0);
        gl.glLightfv(16384, 4609, this.lightDiffuse, 0);
        gl.glLightfv(16384, 4611, this.lightPosition, 0);
        gl.glLightfv(16384, 4610, this.lightSpecular, 0);
        gl.glLightf(16384, 4615, 1.0f);
        gl.glLightf(16384, 4616, 0.0f);
        gl.glLightf(16384, 4617, 0.0f);
        gl.glLightModelfv(2899, this.lightAmbient, 0);
        gl.glEnable(2896);
        gl.glEnable(16384);
        gl.glEnable(2884);
        gl.glEnable(2977);
        gl.glLightModelf(33272, 33274.0f);
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        if (this.reset) {
            int width = this._width;
            int height = this._height;
            gl.glViewport(0, 0, width, height);
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            this.glu.gluPerspective(65.0, (double)width / (double)height, this.nearPlane, this.farPlane);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            this.reset = false;
        }
        gl.glClear(16640);
        gl.glLoadIdentity();
        this.updateView(gl);
        gl.glLightfv(16384, 4611, this.lightPosition, 0);
        GLUT glut = new GLUT();
        gl.glEnable(2896);
        gl.glEnable(2903);
        glut.glutWireSphere(1000.0, 32, 32);
        gl.glDisable(2884);
        gl.glColor3f(1.0f, 1.0f, 0.0f);
        glut.glutSolidTeapot(0.5);
        gl.glDisable(2896);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        glut.glutWireTeapot(0.505);
        gl.glScaled(1.0, 1.0, 1.0);
        this.displayAxes(gl);
        gl.glFlush();
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();
        if (height <= 0) {
            height = 1;
        }
        this._height = height;
        this._width = width;
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(65.0, (double)width / (double)height, this.nearPlane, this.farPlane);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    private void updateView(GL gl) {
        gl.glMultMatrixd(this.camera.getView(), 0);
    }

    private void displayAxes(GL gl) {
        gl.glDisable(3553);
        gl.glDisable(2896);
        gl.glDisable(2903);
        gl.glLineWidth(3.0f);
        gl.glColor3d(1.0, 0.0, 0.0);
        gl.glBegin(1);
        gl.glVertex3d(0.0, 0.0, 0.0);
        gl.glVertex3d(1.0, 0.0, 0.0);
        gl.glEnd();
        gl.glColor3d(0.0, 1.0, 0.0);
        gl.glBegin(1);
        gl.glVertex3d(0.0, 0.0, 0.0);
        gl.glVertex3d(0.0, 1.0, 0.0);
        gl.glEnd();
        gl.glColor3d(0.0, 0.0, 1.0);
        gl.glBegin(1);
        gl.glVertex3d(0.0, 0.0, 0.0);
        gl.glVertex3d(0.0, 0.0, 1.0);
        gl.glEnd();
        gl.glLineWidth(1.0f);
        gl.glColor3d(1.0, 1.0, 1.0);
    }

    private void updateViewMatrix(GL gl) {
        double[] view = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.vLook.normalize();
        Vector3d.cross(this.vRight, this.vLook, this.vUp);
        this.vRight.normalize();
        Vector3d.cross(this.vUp, this.vRight, this.vLook);
        this.vUp.normalize();
        view[0] = this.vRight.x;
        view[1] = this.vUp.x;
        view[2] = -this.vLook.x;
        view[3] = 0.0;
        view[4] = this.vRight.y;
        view[5] = this.vUp.y;
        view[6] = -this.vLook.y;
        view[7] = 0.0;
        view[8] = this.vRight.z;
        view[9] = this.vUp.z;
        view[10] = -this.vLook.z;
        view[11] = 0.0;
        view[12] = -Vector3d.dot(this.vRight, this.vEye);
        view[13] = -Vector3d.dot(this.vUp, this.vEye);
        view[14] = Vector3d.dot(this.vLook, this.vEye);
        view[15] = 1.0;
        gl.glMultMatrixd(view, 0);
    }

    public double[] matRotate(double[] mat, double angle, Vector3d axis) {
        double s = Math.sin(angle * Math.PI / 180.0);
        double c = Math.cos(angle * Math.PI / 180.0);
        axis.normalize();
        mat[0] = c + (1.0 - c) * axis.x;
        mat[1] = (1.0 - c) * axis.x * axis.y + s * axis.z;
        mat[2] = (1.0 - c) * axis.x * axis.z - s * axis.y;
        mat[3] = 0.0;
        mat[4] = (1.0 - c) * axis.y * axis.x - s * axis.z;
        mat[5] = c + (1.0 - c) * Math.pow(axis.y, 2.0);
        mat[6] = (1.0 - c) * axis.y * axis.z + s * axis.x;
        mat[7] = 0.0;
        mat[8] = (1.0 - c) * axis.z * axis.x + s * axis.y;
        mat[9] = (1.0 - c) * axis.z * axis.z - s * axis.x;
        mat[10] = c + (1.0 - c) * Math.pow(axis.z, 2.0);
        mat[11] = 0.0;
        mat[12] = 0.0;
        mat[13] = 0.0;
        mat[14] = 0.0;
        mat[15] = 1.0;
        return mat;
    }

    public Vector3d transformVector(double[] mat, Vector3d vec) {
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        vec.x = x * mat[0] + y * mat[4] + z * mat[8];
        vec.y = x * mat[1] + y * mat[5] + z * mat[9];
        vec.z = x * mat[2] + y * mat[6] + z * mat[10];
        return vec;
    }

    public void rotateLookVector(double angle) {
        double a = angle * Math.PI / 180.0;
        Quat4f q1 = new Quat4f((float)this.vUp.x, (float)this.vUp.y, (float)this.vUp.z, 0.0f);
        Quat4f q2 = new Quat4f((float)(this.vLook.x * Math.sin(a / 2.0)), (float)(this.vLook.y * Math.sin(a / 2.0)), (float)(this.vLook.z * Math.sin(a / 2.0)), (float)Math.cos(a / 2.0));
        Quat4f q3 = new Quat4f();
        q3 = Quat4f.mult(q2, Quat4f.mult(q1, Quat4f.conjugate(q2)));
        this.vUp.x = q3.x;
        this.vUp.y = q3.y;
        this.vUp.z = q3.z;
    }
}

