/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class MouseHandler
extends MouseInputAdapter {
    private Renderer renderer;
    private TestFPS thePanel;
    private boolean leftButtonDown = false;
    private boolean middleButtonDown = false;
    private boolean rightButtonDown = false;

    public MouseHandler(Renderer renderer, TestFPS thePanel) {
        this.renderer = renderer;
        this.thePanel = thePanel;
    }

    public void mouseClicked(MouseEvent e) {
        this.thePanel.requestFocusInWindow();
        if (!this.thePanel.useAnimator) {
            this.thePanel.drawabledisplay();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.thePanel.requestFocusInWindow();
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.leftButtonDown = true;
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            this.middleButtonDown = true;
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.rightButtonDown = true;
        }
        if (!this.thePanel.useAnimator) {
            this.thePanel.drawabledisplay();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.leftButtonDown = false;
        } else if (SwingUtilities.isMiddleMouseButton(e)) {
            this.middleButtonDown = false;
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.rightButtonDown = false;
        }
        if (!this.thePanel.useAnimator) {
            this.thePanel.drawabledisplay();
        }
    }

    public void mouseMoved(MouseEvent e) {
        Point mousePoint = e.getPoint();
        this.renderer.currentMousePoint.x = mousePoint.x;
        this.renderer.currentMousePoint.y = mousePoint.y;
        this.renderer.lastMousePoint.x = this.renderer.currentMousePoint.x;
        this.renderer.lastMousePoint.y = this.renderer.currentMousePoint.y;
        if (!this.thePanel.useAnimator) {
            this.thePanel.drawabledisplay();
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.thePanel.requestFocusInWindow();
        if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isMiddleMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
            Point mousePoint = e.getPoint();
            this.renderer.currentMousePoint.x = mousePoint.x;
            this.renderer.currentMousePoint.y = mousePoint.y;
            int xDiff = this.renderer.currentMousePoint.x - this.renderer.lastMousePoint.x;
            int yDiff = this.renderer.currentMousePoint.y - this.renderer.lastMousePoint.y;
            if (this.leftButtonDown) {
                if (yDiff != 0) {
                    this.renderer.camera.rotateAroundRightVector((double)(-yDiff) / 3.0);
                }
                if (xDiff != 0) {
                    this.renderer.camera.rotateAroundUpVector((double)(-xDiff) / 3.0);
                }
            }
            if (this.middleButtonDown && yDiff != 0) {
                this.renderer.camera.moveFwd((double)yDiff * this.renderer.camera.getMoveSpeed());
            }
            if (this.rightButtonDown) {
                if (xDiff != 0) {
                    System.out.println("  xDiff: " + xDiff);
                    this.renderer.camera.moveLeft((double)xDiff * this.renderer.camera.getMoveSpeed() * 0.1);
                }
                if (yDiff != 0) {
                    this.renderer.camera.moveUp((double)yDiff * this.renderer.camera.getMoveSpeed() * 0.1);
                }
            }
            this.renderer.lastMousePoint.x = this.renderer.currentMousePoint.x;
            this.renderer.lastMousePoint.y = this.renderer.currentMousePoint.y;
        }
        if (!this.thePanel.useAnimator) {
            this.thePanel.drawabledisplay();
        }
    }
}

