/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class KeyHandler
extends KeyAdapter {
    private Renderer renderer;
    private TestFPS thePanel;
    private boolean up = false;
    private boolean down = false;
    private boolean left = false;
    private boolean right = false;
    private boolean pageup = false;
    private boolean pagedown = false;
    private boolean rollleft = false;
    private boolean rollright = false;
    private boolean ctrldown = false;

    public KeyHandler(Renderer renderer, TestFPS thePanel) {
        this.thePanel = thePanel;
        this.renderer = renderer;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 17: {
                this.ctrldown = true;
                break;
            }
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 46: 
            case 65: 
            case 68: 
            case 83: 
            case 87: {
                if (keyCode == 87 || keyCode == 38) {
                    this.up = true;
                }
                if (keyCode == 83 || keyCode == 40) {
                    this.down = true;
                }
                if (keyCode == 65 || keyCode == 37) {
                    this.left = true;
                }
                if (keyCode == 68 || keyCode == 39) {
                    this.right = true;
                }
                if (keyCode == 33) {
                    this.pageup = true;
                }
                if (keyCode == 34) {
                    this.pagedown = true;
                }
                if (keyCode == 44) {
                    this.rollleft = true;
                }
                if (keyCode == 46) {
                    this.rollright = true;
                }
                e.consume();
                this.cameraUpdate();
                break;
            }
            default: {
                this.processKeyEvent(e);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 17: {
                this.ctrldown = false;
                break;
            }
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 46: 
            case 65: 
            case 68: 
            case 83: 
            case 87: {
                if (keyCode == 87 || keyCode == 38) {
                    this.up = false;
                } else if (keyCode == 83 || keyCode == 40) {
                    this.down = false;
                } else if (keyCode == 65 || keyCode == 37) {
                    this.left = false;
                } else if (keyCode == 68 || keyCode == 39) {
                    this.right = false;
                } else if (keyCode == 33) {
                    this.pageup = false;
                } else if (keyCode == 34) {
                    this.pagedown = false;
                } else if (keyCode == 44) {
                    this.rollleft = false;
                } else if (keyCode == 46) {
                    this.rollright = false;
                }
                e.consume();
                this.cameraUpdate();
                break;
            }
        }
    }

    private void processKeyEvent(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 70: {
                this.renderer.camera.setEmulateFPS(!this.renderer.camera.getEmulateFPS());
                break;
            }
            case 49: {
                this.renderer.camera.setEye(new Vector3d(0.0, -2.0, 0.0));
                this.renderer.camera.lookAt(new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0));
                break;
            }
            case 50: {
                this.renderer.camera.setEye(new Vector3d(-2.0, 0.0, 0.0));
                this.renderer.camera.lookAt(new Vector3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0));
                break;
            }
            case 51: {
                this.renderer.camera.setEye(new Vector3d(0.0, 0.0, -2.0));
                this.renderer.camera.lookAt(new Vector3d(0.0, 0.0, 0.0), new Vector3d(1.0, 0.0, 0.0));
                break;
            }
            case 79: {
                this.renderer.camera.setOrbit(!this.renderer.camera.getOrbit());
                break;
            }
            case 74: {
                this.renderer.camera.tmpEye.x += 0.25;
                this.renderer.camera.tmpEye.y += 0.25;
                this.renderer.camera.tmpEye.z += 0.25;
                System.out.println(" J BUTTON ");
                break;
            }
            case 75: {
                this.renderer.camera.tmpEye.x -= 0.25;
                this.renderer.camera.tmpEye.y -= 0.25;
                this.renderer.camera.tmpEye.z -= 0.25;
                System.out.println(" K BUTTON ");
                break;
            }
        }
        if (!this.thePanel.useAnimator) {
            this.thePanel.drawabledisplay();
        }
    }

    private void cameraUpdate() {
        if (this.up) {
            if (this.ctrldown) {
                this.renderer.camera.rotateAroundRightVector(-1.0);
            } else {
                this.renderer.camera.stepFwd();
            }
        }
        if (this.down) {
            if (this.ctrldown) {
                this.renderer.camera.rotateAroundRightVector(1.0);
            } else {
                this.renderer.camera.stepBack();
            }
        }
        if (this.left) {
            if (this.ctrldown) {
                this.renderer.camera.rotateAroundUpVector(1.0);
            } else {
                this.renderer.camera.stepLeft();
            }
        }
        if (this.right) {
            if (this.ctrldown) {
                this.renderer.camera.rotateAroundUpVector(-1.0);
            } else {
                this.renderer.camera.stepRight();
            }
        }
        if (this.pageup) {
            this.renderer.camera.stepUp();
        }
        if (this.pagedown) {
            this.renderer.camera.stepDown();
        }
        if (this.rollleft) {
            this.renderer.camera.rotateAroundLookVector(-1.0);
        }
        if (this.rollright) {
            this.renderer.camera.rotateAroundLookVector(1.0);
        }
        if (!this.thePanel.useAnimator) {
            this.thePanel.drawabledisplay();
        }
    }
}

