/*
 * Decompiled with CFR 0.152.
 */
public class Camera {
    public static final String VERSION_STRING = "@(#)$Id$";
    private static boolean _debug = Boolean.getBoolean("debugging") || Boolean.getBoolean("nasaops.cts.display.jogl") || Boolean.getBoolean("Camera.debugging");
    private Vector3d look = new Vector3d(-0.05, -0.05, -0.05);
    private Vector3d eye = new Vector3d(1.0, 1.0, 1.0);
    private Vector3d up = new Vector3d(0.0, 1.0, 0.0);
    private Vector3d right = new Vector3d(1.0, 0.0, 0.0);
    private double[] view = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private double moveSpeed = 0.25;
    private boolean needUpdate = false;
    private boolean emulateFPS = false;
    private boolean orbit = false;
    public Vector3d tmpEye = new Vector3d();
    private double[] axes = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};

    public Camera() {
        this.needUpdate = true;
        this.apply();
    }

    public Camera(Vector3d lookVector, Vector3d eyePoint, Vector3d upVector) {
        this.setLook(lookVector);
        this.setEye(eyePoint);
        this.setUp(upVector);
        this.apply();
    }

    public void setLook(Vector3d vec) {
        if (vec == null) {
            throw new RuntimeException("Look vector cannot be null.");
        }
        if (Math.abs(vec.length()) < 1.0E-6) {
            throw new RuntimeException("Look vector cannot have zero length.");
        }
        this.look.x = vec.x;
        this.look.y = vec.y;
        this.look.z = vec.z;
        this.look.normalize();
        this.needUpdate = true;
    }

    public void setEye(Vector3d pt) {
        if (pt == null) {
            throw new RuntimeException("Eye point cannot be null.");
        }
        this.eye.x = pt.x;
        this.eye.y = pt.y;
        this.eye.z = pt.z;
        this.needUpdate = true;
    }

    public void setUp(Vector3d vec) {
        if (vec == null) {
            throw new RuntimeException("Up vector cannot be null.");
        }
        if (Math.abs(vec.length()) < 1.0E-6) {
            throw new RuntimeException("Up vector cannot have zero length.");
        }
        this.up.x = vec.x;
        this.up.y = vec.y;
        this.up.z = vec.z;
        this.up.normalize();
        this.needUpdate = true;
    }

    public Vector3d getLookCopy() {
        return new Vector3d(this.look);
    }

    public Vector3d getLook() {
        return this.look;
    }

    public Vector3d getEyeCopy() {
        return new Vector3d(this.eye);
    }

    public Vector3d getEye() {
        return this.eye;
    }

    public Vector3d getUpCopy() {
        return new Vector3d(this.up);
    }

    public Vector3d getUp() {
        return this.up;
    }

    public Vector3d getRightCopy() {
        return new Vector3d(this.right);
    }

    public void lookAt(Vector3d lookPoint, Vector3d upVector) {
        if (lookPoint == null) {
            throw new RuntimeException("Look point cannot be null.");
        }
        if (upVector == null) {
            throw new RuntimeException("Up vector cannot be null.");
        }
        if (Math.abs(upVector.length()) < 1.0E-6) {
            throw new RuntimeException("Up vector cannot have zero length.");
        }
        Vector3d lookVector = new Vector3d();
        lookVector.sub(lookPoint, this.eye);
        if (_debug) {
            System.out.println("---- lookAt() ------------------------------------");
            System.out.println("Look Vector = look point - eye point \n   look point: " + lookPoint + "\n    eye point: " + this.eye + "\n  look vector: " + lookVector);
        }
        if (Math.abs(lookVector.length()) < 1.0E-6) {
            System.err.println("Camera look vector cannot have zero length.  This is likely caused by coincidant 'look at' and 'eye' point locations.  Forcing look vector to <1,0,0>");
            lookVector.x = 1.0;
            lookVector.y = 0.0;
            lookVector.z = 0.0;
        }
        this.setLook(lookVector);
        this.setUp(upVector);
        this.needUpdate = true;
    }

    public void apply() {
        if (!this.needUpdate) {
            return;
        }
        this.updateView();
        double[] R = this.matmult(this.axes, this.view);
        for (int i = 0; i < 16; ++i) {
            this.view[i] = R[i];
        }
        this.tmpEye.x = this.view[12];
        this.tmpEye.y = this.view[13];
        this.tmpEye.z = this.view[14];
    }

    public double[] matmult(double[] one, double[] two) {
        double[] R = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        R[0] = one[0] * two[0] + one[1] * two[4] + one[2] * two[8] + one[3] * two[12];
        R[1] = one[0] * two[1] + one[1] * two[5] + one[2] * two[9] + one[3] * two[13];
        R[2] = one[0] * two[2] + one[1] * two[6] + one[2] * two[10] + one[3] * two[14];
        R[3] = one[0] * two[3] + one[1] * two[7] + one[2] * two[11] + one[3] * two[15];
        R[4] = one[4] * two[0] + one[5] * two[4] + one[6] * two[8] + one[7] * two[12];
        R[5] = one[4] * two[1] + one[5] * two[5] + one[6] * two[9] + one[7] * two[13];
        R[6] = one[4] * two[2] + one[5] * two[6] + one[6] * two[10] + one[7] * two[14];
        R[7] = one[4] * two[3] + one[5] * two[7] + one[6] * two[11] + one[7] * two[15];
        R[8] = one[8] * two[0] + one[9] * two[4] + one[10] * two[8] + one[11] * two[12];
        R[9] = one[8] * two[1] + one[9] * two[5] + one[10] * two[9] + one[11] * two[13];
        R[10] = one[8] * two[2] + one[9] * two[6] + one[10] * two[10] + one[11] * two[14];
        R[11] = one[8] * two[3] + one[9] * two[7] + one[10] * two[11] + one[11] * two[15];
        R[12] = one[12] * two[0] + one[13] * two[4] + one[14] * two[8] + one[15] * two[12];
        R[13] = one[12] * two[1] + one[13] * two[5] + one[14] * two[9] + one[15] * two[13];
        R[14] = one[12] * two[2] + one[13] * two[6] + one[14] * two[10] + one[15] * two[14];
        R[15] = one[12] * two[3] + one[13] * two[7] + one[14] * two[11] + one[15] * two[15];
        return R;
    }

    public void updateAxes(double[] a) {
        for (int i = 0; i < 16; ++i) {
            this.axes[i] = a[i];
        }
    }

    private void updateView() {
        if (Math.abs(this.look.length()) < 1.0E-6) {
            throw new RuntimeException("Look vector cannot have zero length.");
        }
        this.look.normalize();
        Vector3d.cross(this.right, this.look, this.up);
        if (Math.abs(this.right.length()) < 1.0E-6) {
            throw new RuntimeException("Right vector cannot have zero length.");
        }
        this.right.normalize();
        Vector3d.cross(this.up, this.right, this.look);
        if (Math.abs(this.up.length()) < 1.0E-6) {
            throw new RuntimeException("Up vector cannot have zero length.");
        }
        this.up.normalize();
        this.view[0] = this.right.x;
        this.view[1] = this.up.x;
        this.view[2] = -this.look.x;
        this.view[3] = 0.0;
        this.view[4] = this.right.y;
        this.view[5] = this.up.y;
        this.view[6] = -this.look.y;
        this.view[7] = 0.0;
        this.view[8] = this.right.z;
        this.view[9] = this.up.z;
        this.view[10] = -this.look.z;
        this.view[11] = 0.0;
        if (!this.orbit) {
            this.view[12] = -Vector3d.dot(this.right, this.eye);
            this.view[13] = -Vector3d.dot(this.up, this.eye);
            this.view[14] = Vector3d.dot(this.look, this.eye);
            this.view[15] = 1.0;
        } else {
            this.view[12] = this.tmpEye.x;
            this.view[13] = this.tmpEye.y;
            this.view[14] = this.tmpEye.z;
            this.view[15] = 1.0;
        }
        if (_debug) {
            System.out.println("---- updateView() --------------------------------");
            System.out.println("   look: " + this.look + "\n    eye: " + this.eye + "\n     up: " + this.up + "\n  right: " + this.right);
            System.out.println("   view matrix:");
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    System.out.print("  " + this.view[4 * i + j]);
                }
                System.out.println("");
            }
        }
        this.needUpdate = false;
    }

    public double[] getViewCopy() {
        this.checkUpdate();
        double[] viewCopy = new double[16];
        for (int i = 0; i < 16; ++i) {
            viewCopy[i] = this.view[i];
        }
        return viewCopy;
    }

    public double[] getView() {
        this.checkUpdate();
        return this.view;
    }

    private void checkUpdate() {
        if (this.needUpdate) {
            this.apply();
        }
    }

    public void rotateAroundLookVector(double angle) {
        if (!this.emulateFPS) {
            this.setUp(this.rotateVector(angle, this.up, this.look));
        }
    }

    public void rotateAroundUpVector(double angle) {
        double[] matrotation = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        matrotation = this.emulateFPS ? this.matRotate(matrotation, angle, new Vector3d(0.0, 1.0, 0.0)) : this.matRotate(matrotation, angle, this.up);
        this.look = this.transformVector(matrotation, this.look);
        this.up = this.transformVector(matrotation, this.up);
        this.right = this.transformVector(matrotation, this.right);
        this.needUpdate = true;
    }

    public double[] matRotate(double[] mat, double angle, Vector3d axis) {
        double s = Math.sin(angle * Math.PI / 180.0);
        double c = Math.cos(angle * Math.PI / 180.0);
        axis.normalize();
        mat[0] = c + (1.0 - c) * axis.x;
        mat[1] = (1.0 - c) * axis.x * axis.y + s * axis.z;
        mat[2] = (1.0 - c) * axis.x * axis.z - s * axis.y;
        mat[3] = 0.0;
        mat[4] = (1.0 - c) * axis.y * axis.x - s * axis.z;
        mat[5] = c + (1.0 - c) * Math.pow(axis.y, 2.0);
        mat[6] = (1.0 - c) * axis.y * axis.z + s * axis.x;
        mat[7] = 0.0;
        mat[8] = (1.0 - c) * axis.z * axis.x + s * axis.y;
        mat[9] = (1.0 - c) * axis.z * axis.z - s * axis.x;
        mat[10] = c + (1.0 - c) * Math.pow(axis.z, 2.0);
        mat[11] = 0.0;
        mat[12] = 0.0;
        mat[13] = 0.0;
        mat[14] = 0.0;
        mat[15] = 1.0;
        return mat;
    }

    public Vector3d transformVector(double[] mat, Vector3d vec) {
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        vec.x = x * mat[0] + y * mat[4] + z * mat[8];
        vec.y = x * mat[1] + y * mat[5] + z * mat[9];
        vec.z = x * mat[2] + y * mat[6] + z * mat[10];
        return vec;
    }

    public void rotateAroundRightVector(double angle) {
        this.setLook(this.rotateVector(angle, this.look, this.right));
        Vector3d.cross(this.up, this.right, this.look);
        if (Math.abs(this.up.length()) < 1.0E-6) {
            throw new RuntimeException("Up vector cannot have zero length.");
        }
        this.up.normalize();
    }

    public void stepLeft() {
        this.moveLeftRight(-this.moveSpeed);
    }

    public void stepRight() {
        this.moveLeftRight(this.moveSpeed);
    }

    public void moveLeft(double step) {
        this.moveLeftRight(-step);
    }

    public void moveRight(double step) {
        this.moveLeftRight(step);
    }

    public void moveLeftRight(double step) {
        if (!this.orbit) {
            Vector3d tmpRight = this.getRightCopy();
            this.eye.x += tmpRight.x * step;
            this.eye.y += tmpRight.y * step;
            this.eye.z += tmpRight.z * step;
        } else {
            this.tmpEye.x -= step;
        }
        this.needUpdate = true;
    }

    public void stepFwd() {
        this.moveFwdBack(this.moveSpeed);
    }

    public void stepBack() {
        this.moveFwdBack(-this.moveSpeed);
    }

    public void moveFwd(double step) {
        this.moveFwdBack(step);
    }

    public void moveBack(double step) {
        this.moveFwdBack(-step);
    }

    public void moveFwdBack(double step) {
        if (!this.orbit) {
            Vector3d tmpLook = this.getLookCopy();
            this.eye.x += tmpLook.x * step;
            this.eye.y += tmpLook.y * step;
            this.eye.z += tmpLook.z * step;
        } else {
            this.tmpEye.z += step;
        }
        this.needUpdate = true;
    }

    public void stepUp() {
        this.moveUpDown(this.moveSpeed);
    }

    public void stepDown() {
        this.moveUpDown(-this.moveSpeed);
    }

    public void moveUp(double step) {
        this.moveUpDown(step);
    }

    public void moveDown(double step) {
        this.moveUpDown(-step);
    }

    public void moveUpDown(double step) {
        if (!this.orbit) {
            if (this.emulateFPS) {
                this.eye.y += step;
            } else {
                Vector3d tmpUp = this.getUpCopy();
                this.eye.x += tmpUp.x * step;
                this.eye.y += tmpUp.y * step;
                this.eye.z += tmpUp.z * step;
            }
        } else {
            this.tmpEye.y -= step;
        }
        this.needUpdate = true;
    }

    private Vector3d rotateVector(double angle, Vector3d rotationVector, Vector3d rotateAboutVector) {
        double a = angle * Math.PI / 180.0;
        Quat4f q1 = new Quat4f((float)rotationVector.x, (float)rotationVector.y, (float)rotationVector.z, 0.0f);
        Quat4f q2 = new Quat4f((float)(rotateAboutVector.x * Math.sin(a / 2.0)), (float)(rotateAboutVector.y * Math.sin(a / 2.0)), (float)(rotateAboutVector.z * Math.sin(a / 2.0)), (float)Math.cos(a / 2.0));
        Quat4f q3 = new Quat4f();
        q3 = Quat4f.mult(q2, Quat4f.mult(q1, Quat4f.conjugate(q2)));
        Vector3d rotatedVector = new Vector3d(q3.x, q3.y, q3.z);
        if (Math.abs(rotatedVector.length()) < 1.0E-6) {
            throw new RuntimeException("Rotated vector cannot have zero length.");
        }
        rotatedVector.normalize();
        return rotatedVector;
    }

    public void setMoveSpeed(double speed) {
        this.moveSpeed = speed;
    }

    public double getMoveSpeed() {
        return this.moveSpeed;
    }

    public void setEmulateFPS(boolean state) {
        this.emulateFPS = state;
    }

    public boolean getEmulateFPS() {
        return this.emulateFPS;
    }

    public boolean getOrbit() {
        return this.orbit;
    }

    public void setOrbit(boolean state) {
        this.orbit = state;
    }

    public String toString() {
        return new String("Camera Properties:\n  Look Vector: " + this.look + "\n   Eye Vector: " + this.eye + "\n    Up Vector: " + this.up + "\n Right Vector: " + this.right);
    }
}

